IF EXISTS (SELECT 1 FROM SYS.PROCEDURES WHERE NAME ='P_WEB_CONV_WEB_CONV_DEMITE')
    BEGIN 
	   DROP PROCEDURE P_WEB_CONV_WEB_CONV_DEMITE
    END 
GO

CREATE PROCEDURE P_WEB_CONV_WEB_CONV_DEMITE (@cdConv    INT
								    , @dataIni   DATE    = NULL
								    , @dataFim   DATE    = NULL
								    , @Resultype TINYINT = 1
								    , @nome_cli  VARCHAR(225) = NULL
								    )
AS
BEGIN
----------------------------------------------------------------------------------------------------

IF @Resultype=1
begin
	Create table #RsRet01(QTDE_PONTOS		money
							,FLAG_CLI_FIDEL		tinyint
							,RZ_CLI				varchar(200)
							,CGC_CPF			varchar(20)
							,CD_CLI				int
							,MATRICULA			varchar(50)
							,VLR_CRED			money
							,VLR_DEB			money
							,NR_CARTAO			varchar(20)
							,DS_PLANO_VENDA		varchar(50)
							,DT_CAD				datetime
							,DATA_FAT			date
							,CD_CONV_DEMITE		int
							,DT_DISP			datetime
							,DT_FECH_AGD		date 
							,DEMITE_MONTH		int
							,DEMITE_DAY			int
							,DIA_FAT			int
							,NOME_DEMITIDO		varchar(200))
end

IF @Resultype=2
BEGIN 
	Create table #RsRet02(CD_CONV_DEMITE int	
						,QDE		int
						,SOLICITANTE	varchar(200)
						,ORIGEM		varchar(200)
						,CD_CONV		   int
						,DT_CAD			  datetime
						,DT_DISP			  datetime
						,CD_CLI			int
						,NR_CARTAO		varchar(20)
						,MATRICULA		varchar(50)
						,RZ_CLI			varchar(200)
						,DIA_FAT		int
						,DT_FECH_AGD	date 
						,DEMITE_MONTH	int
						,DEMITE_DAY	  	int
						,DATA_FAT		date)
END 

--drop Table #RsRet
----------------------------------------------------------------------------------------------------
	IF @Resultype = 1
		BEGIN
			INSERT INTO #RsRet01
			SELECT
				CLI.QTDE_PONTOS
				, CLI.FLAG_CLI_FIDEL
				, CLI.RZ_CLI
				, CLI.CGC_CPF
				, CONV.CD_CLI
				, CONV.MATRICULA
				, CONV.VLR_CRED
				, CONV.VLR_DEB
				, CAR.NR_CARTAO
				, ISNULL(E.DS_PLANO_VENDA , 'NAO DEFINIDO') DS_PLANO_VENDA
				, DEMITE.DT_CAD
				, DT_FECH_AGD DATA_FAT
				, DEMITE.CD_CONV_DEMITE
				, DEMITE.DT_DISP
				, DT_FECH_AGD 
				, MONTH(DEMITE.DT_CAD) DEMITE_MONTH
				, DAY(DEMITE.DT_CAD) DEMITE_DAY
				, RC_CLI_CONV.DIA_FAT
				, CASE
					WHEN CLI_DEMITIDO.RZ_CLI IS NOT NULL THEN CLI_DEMITIDO.RZ_CLI
					WHEN CLI_DEMITIDO.RZ_CLI IS NULL
							AND USU_DEMITIDO.NM_USU IS NOT NULL THEN USU_DEMITIDO.NM_USU
					WHEN USU_DEMITIDO.NM_USU IS NULL
							AND USU_DEMITIDO.NM_USU IS NULL THEN VDEMIT.SOLICITANTE
				END AS NOME_DEMITIDO  
			FROM
				RC_CLI_CONV_RC_CLI AS CONV
				LEFT JOIN RC_CLI_FIDELI_CARTAO AS CAR ON CONV.CD_EMP = CAR.CD_EMP
														AND CONV.CD_CLI = CAR.CD_CLI
				INNER JOIN RC_CLI AS CLI ON CONV.CD_EMP = CLI.CD_EMP
											AND CONV.CD_CLI = CLI.CD_CLI
				INNER JOIN RC_CLI_CONV ON CONV.CD_EMP = RC_CLI_CONV.CD_EMP
										AND CONV.CD_CONV = RC_CLI_CONV.CD_CONV
				INNER JOIN WEB_CONV_DEMITE AS DEMITE ON CONV.CD_CONV = DEMITE.CD_CONV
				LEFT JOIN RC_CLI AS CLI_DEMITIDO ON DEMITE.CD_CLI = CLI_DEMITIDO.CD_CLI
				LEFT JOIN GLB_USU AS USU_DEMITIDO ON DEMITE.CD_USU = USU_DEMITIDO.CD_USU
				INNER JOIN WEB_CONV_DEMITE_RC_CLI AS REA ON DEMITE.CD_CONV_DEMITE = REA.CD_CONV_DEMITE
															AND CONV.CD_CLI = REA.CD_CLI
				LEFT JOIN GLB_PLANO_VENDA AS E ON CONV.CD_PLANO_VENDA = E.CD_PLANO_VENDA
				LEFT JOIN V_WEB_LIST_DEMISSOES AS VDEMIT ON DEMITE.CD_CONV_DEMITE = VDEMIT.CD_CONV_DEMITE
				LEFT JOIN RC_CLI_CONV_AGD_FECH AS AGD ON CONV.CD_CONV = AGD.CD_CONV
														AND YEAR(AGD.DT_FECH_CONV) = YEAR(DEMITE.DT_CAD)
														AND MONTH(AGD.DT_FECH_CONV) = MONTH(DEMITE.DT_CAD)
			WHERE  CONV.FLAG_CONVENIADO_DEMISSAO = 1
				AND CONV.CD_EMP = 1
				AND CONV.CD_CONV = @cdConv
				AND CASE WHEN @dataIni IS NULL  THEN CONVERT(DATE, DEMITE.DT_DISP) 
					   ELSE @dataIni END <=CONVERT(DATE, DEMITE.DT_DISP) 

				AND CASE WHEN @dataFim IS NULL  THEN CONVERT(DATE, DEMITE.DT_DISP) 
					   ELSE @dataFim END >=CONVERT(DATE, DEMITE.DT_DISP) 
				AND CONV.STS_ATIVO = 1
				AND REA.DT_READMISSAO IS NULL
				AND CLI.RZ_CLI LIKE CASE WHEN @nome_cli IS NULL THEN '%%'
									ELSE '%'+@nome_cli+'%'
						   END
		END;
----------------------------------------------------------------------------------------------------
	IF @Resultype = 2
		BEGIN
			INSERT INTO #RsRet02
			SELECT
				V.CD_CONV_DEMITE
				, V.QDE
				, V.SOLICITANTE
				, V.ORIGEM
				, V.CD_CONV
				, V.DT_CAD
				, V.DT_DISP
				, REA.CD_CLI
				, CAR.NR_CARTAO
				, CLI.MATRICULA
				, CLI.RZ_CLI
				, RC_CLI_CONV.DIA_FAT
				, DT_FECH_AGD 
				, MONTH	(V.DT_CAD)  DEMITE_MONTH
				, DAY	(V.DT_CAD)  DEMITE_DAY
				, DT_FECH_AGD DATA_FAT
 
			FROM
				V_WEB_LIST_DEMISSOES AS V
				INNER JOIN WEB_CONV_DEMITE_RC_CLI AS REA ON V.CD_CONV_DEMITE = REA.CD_CONV_DEMITE
				INNER JOIN RC_CLI_CONV_RC_CLI CLI_CONV ON CLI_CONV.CD_EMP = REA.CD_EMP 
												  AND CLI_CONV.CD_CONV = V.CD_CONV 
												  AND  CLI_CONV.CD_CLI = REA.CD_CLI
				INNER JOIN RC_CLI AS CLI ON REA.CD_EMP		= CLI.CD_EMP
											AND REA.CD_CLI	= CLI.CD_CLI
				INNER JOIN RC_CLI_CONV ON V.CD_CONV = RC_CLI_CONV.CD_CONV
				LEFT JOIN RC_CLI_FIDELI_CARTAO AS CAR ON REA.CD_EMP  = CAR.CD_EMP 
														 AND REA.CD_CLI = CAR.CD_CLI
				LEFT JOIN RC_CLI_CONV_AGD_FECH AS AGD ON v.CD_CONV = AGD.CD_CONV
														AND YEAR(AGD.DT_FECH_CONV)  = YEAR(V.DT_CAD)
														AND MONTH(AGD.DT_FECH_CONV) = MONTH(V.DT_CAD)
			WHERE  
				CLI.CD_EMP=1
				AND RC_CLI_CONV.CD_EMP=1
				AND V.CD_CONV = @cdConv
				AND CASE WHEN @dataIni IS NULL  THEN CONVERT(DATE, V.DT_CAD) 
					   ELSE @dataIni END <=CONVERT(DATE, V.DT_CAD) 

				AND CASE WHEN @dataFim IS NULL  THEN CONVERT(DATE, V.DT_CAD) 
					   ELSE @dataFim END >=CONVERT(DATE, V.DT_CAD) 
				AND CLI.RZ_CLI LIKE CASE WHEN @nome_cli IS NULL THEN '%%'
									ELSE '%'+@nome_cli+'%'
						   END
		END;
	
----------------------------------------------------------------------------------------------------
-- Define DataFat 
	 
IF @Resultype = 1
	BEGIN
		 UPDATE #RsRet01 SET DIA_FAT = 28
		WHERE
			DEMITE_MONTH = 2
			AND DIA_FAT > 28;
	
		UPDATE #RsRet01 SET DIA_FAT = 30
		WHERE
			DEMITE_MONTH IN(4, 6, 9, 11)
			AND DIA_FAT > 30;

		UPDATE #RsRet01
		SET
			DATA_FAT =  CONVERT(DATE, CAST(YEAR(DT_CAD) AS VARCHAR)+'-'+CAST(MONTH(DT_CAD) AS VARCHAR)+'-'+CAST(DIA_FAT AS VARCHAR))					
		WHERE
			DT_FECH_AGD IS NULL;

		UPDATE #RsRet01
		SET
			DATA_FAT = DT_CAD
		WHERE
			DT_CAD < DATA_FAT
			AND DT_FECH_AGD IS NULL;
	END


IF @Resultype = 2
	BEGIN
		UPDATE #RsRet02 SET DIA_FAT = 28
		WHERE
			DEMITE_MONTH = 2
			AND DIA_FAT > 28;
	
		UPDATE #RsRet02 SET DIA_FAT = 30
		WHERE
			DEMITE_MONTH IN(4, 6, 9, 11)
			AND DIA_FAT > 30;

		UPDATE #RsRet02
		SET
			DATA_FAT =  CONVERT(DATE, CAST(YEAR(DT_CAD) AS VARCHAR)+'-'+CAST(MONTH(DT_CAD) AS VARCHAR)+'-'+CAST(DIA_FAT AS VARCHAR))					
		WHERE
			DT_FECH_AGD IS NULL;

		UPDATE #RsRet02
		SET
			DATA_FAT = DT_CAD
		WHERE
			DT_CAD < DATA_FAT
			AND DT_FECH_AGD IS NULL;
	END
	 
			 
----------------------------------------------------------------------------------------------------
-- Main result
IF @Resultype = 1
	BEGIN
		SELECT*FROM #Rsret01;
	END

	IF @Resultype = 2
	BEGIN
		SELECT*FROM #Rsret02;
	end
END;
go


